<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$langFrm->setFormTagAttribute('id', 'bpCat');
$langFrm->setFormTagAttribute('class', 'form web_form layout--' . $formLayout);
$langFrm->developerTags['colClassPrefix'] = 'col-md-';
$langFrm->developerTags['fld_default_col'] = 12;
$langFrm->setFormTagAttribute('dir', $formLayout);
$langFld = $langFrm->getField('lang_id');
$langFld->setfieldTagAttribute('onChange', "langForm(" . $post_id . ", this.value);");
$recordId = (int) $post_id;
$formTitle = Labels::getLabel('LBL_Blog_Post_Setup', $adminLangId);
$tabsButtons = [
    [
        'attr' => [
            'onclick' => 'blogPostForm('.$post_id.')',
            'title' => Labels::getLabel('LBL_General', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_General', $adminLangId),
        'isActive' => false,
        'isPrimary' => true
    ],
	[
        'attr' => [
            'onclick' => (0 < $recordId) ? 'linksForm('.$recordId.')' : '',
            'title' => Labels::getLabel('LBL_Link_Category', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Link_Category', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'langForm("'.$recordId.'","'.FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1).'")' : '',
            'title' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        'isActive' => true
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'postImages('.$recordId.')' : '',
            'title' => Labels::getLabel('LBL_Post_Images', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Post_Images', $adminLangId),
        'isActive' => false
    ],
];
$frm = $langFrm;
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>
<?php
$translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
$siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
if (!empty($translatorSubscriptionKey) && $post_lang_id != $siteDefaultLangId) { ?>
    <div class="row justify-content-end">
        <div class="col-auto mb-4">
            <button type="button" class="btn btn-outline-gray btn-icon btn-language" onClick="langForm(<?php echo $post_id; ?>, <?php echo $post_lang_id; ?>, 1)" title="<?php echo Labels::getLabel('LBL_AUTOFILL_LANGUAGE_DATA', $adminLangId); ?>" data-action="">
                <svg class="svg" width="24" height="24">
                    <use xlink:href="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/retina/sprite-actions.svg#translate"></use>
                </svg>
            </button>
        </div>
    </div>
<?php } ?>
<?php echo $langFrm->getFormHtml(); ?>
<?php 
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>
