<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
<?php
$arr_flds = array(
    'select_all' => Labels::getLabel('LBL_Select_all', $adminLangId),
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    'blocation_name' => Labels::getLabel('LBL_Title', $adminLangId),
    /* 'blocation_banner_width' => Labels::getLabel('LBL_Preffered_Width_(in_pixels)', $adminLangId),
    'blocation_banner_height' => Labels::getLabel('LBL_Preffered_Height_(in_pixels)', $adminLangId), */
    'blocation_promotion_cost' => Labels::getLabel('LBL_Promotion_Cost', $adminLangId),
    'blocation_active' => Labels::getLabel('LBL_Status', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);
if (!$canEdit || empty($arr_listing)) {
    unset($arr_flds['select_all'], $arr_flds['action']);
}

$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $key => $val) {
    if ('select_all' == $key) {
        $th->appendElement('th')->appendElement('plaintext', array(), '<label class="checkbox"><input title="' . $val . '" type="checkbox" onclick="selectAll( $(this) )" class="selectAll-js"></label>', true);
    } else {
        $e = $th->appendElement('th', array(), $val);
    }
}

$sr_no = $page == 1 ? 0 : $pageSize * ($page - 1);
foreach ($arr_listing as $sn => $row) {
    $sr_no++;
    /* $tr = $tbl->appendElement('tr',array('class' => ($row['blocation_active'] != applicationConstants::ACTIVE) ? 'fat-inactive' : '' )); */
    $tr = $tbl->appendElement('tr', array());
    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'select_all':
                $td->appendElement('plaintext', array(), '<label class="checkbox"><input class="selectItem--js" type="checkbox" name="blocation_ids[]" value=' . $row['blocation_id'] . '></label>', true);
                break;
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'blocation_name':
                $infoText = Labels::getLabel('LBL_(_This_Banner_will_be_visible_on_Product_search_page_)', $adminLangId);
                $td->appendElement('plaintext', array(), $row['blocation_name'] . "<br/>" . $infoText, true);
                break;
            case 'blocation_active':
                $active = "";
                if ($row['blocation_active']) {
                    $active = 'checked';
                }
                $statusAct = ($canEdit === true) ? 'toggleStatusBannerLocation(event,this,' . applicationConstants::YES . ')' : 'toggleStatusBannerLocation(event,this,' . applicationConstants::NO . ')';
                $statusClass = ($canEdit === false) ? 'disabled' : '';
                $str = '<label class="switch switch-sm switch-icon ' . $statusClass . '">
                <input ' . $active . ' type="checkbox" id="switch' . $row['blocation_id'] . '" value="' . $row['blocation_id'] . '" onclick="' . $statusAct . '" class="switch-labels"/>
                </label>';
                $td->appendElement('plaintext', array(), $str, true);
                break;
            case 'blocation_promotion_cost':
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
            case 'action':
                if ($canEdit) {

                    $url = UrlHelper::generateUrl('banners', 'listing', array($row['blocation_id']));
                    $actionArr = [
                        [
                            "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                            "onclick" => "addBannerLocation(" . $row['blocation_id'] . ")"
                        ],
                        [
                            "title" => Labels::getLabel('LBL_Banners', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#eye'></use></svg>",
                            "onclick" => 'redirecrt("' . $url . '")'
                        ]
                    ];

                    $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $row['blocation_id']], false);
                }
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}


$frm = new Form('frmBannersLocListing', array('id' => 'frmBannersLocListing'));
$frm->setFormTagAttribute('class', 'form web_form last_td_nowrap actionButtons-js');
$frm->setFormTagAttribute('onsubmit', 'formAction(this, reloadList ); return(false);');
$frm->setFormTagAttribute('action', UrlHelper::generateUrl('Banners', 'toggleBulkStatuses'));
$frm->addHiddenField('', 'status');

echo $frm->getFormTag();
echo $frm->getFieldHtml('status');
echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>

</form>
</div>
<?php $postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array(
    'name' => 'frmBannerSearchPaging'
));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);