<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$mediaFrm->setFormTagAttribute('class', 'form web_form  form_horizontal');
$mediaFrm->developerTags['colClassPrefix'] = 'col-md-';
$mediaFrm->developerTags['fld_default_col'] = 12;

$fld1 = $mediaFrm->getField('banner_image');
$fld1->addFieldTagAttribute('class', 'btn btn-brand btn-sm');
$fld1->addFieldTagAttribute('onChange', 'popupImage(this)');
$langFld = $mediaFrm->getField('lang_id');
$langFld->addFieldTagAttribute('class', 'language-js');

$screenFld = $mediaFrm->getField('banner_screen');
$screenFld->addFieldTagAttribute('class', 'display-js');

if ($blocation_id == BannerLocation::HOME_PAGE_MOBILE_BANNER) {
    $screenFld->setFieldTagAttribute('disabled', 'disabled');
}
$recordId = $blocation_id;
$defaultDimenssion = $dimensions;
$tpl = new FatTemplate('', '');
$tpl->set('adminLangId', $adminLangId);
$instructionHtml = $tpl->render(false, false, '_partial/imageUploadInstructions.php', true, true);

$preferredDimensionsStr = '<span class="uploadimage--info text--small form-text text-muted" ></span><div>' . $instructionHtml . '</div>';

$htmlAfterField = $preferredDimensionsStr;

$fld1->htmlAfterField = $htmlAfterField;
$tabsButtons = [
    [
        'attr' => [
            'onclick' => 'bannerForm(' . $blocation_id . ',' . $banner_id . ')',
            'title' => Labels::getLabel('LBL_General', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_General', $adminLangId),
        'isActive' => false,
        'isPrimary' => true

    ],
    [
        'attr' => [
            'onclick' => 'bannerLangForm(' . $blocation_id . ',' . $banner_id . ',' . FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1) . ')',
            'title' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'onclick' => 'mediaForm(' . $blocation_id . ',' . $banner_id . ')',
            'title' => Labels::getLabel('LBL_MEDIA', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_MEDIA', $adminLangId),
        'isActive' => true
    ]
];

$formTitle = Labels::getLabel('LBL_Banner_Setup', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');

?>
<div >

    <?php echo $mediaFrm->getFormHtml(); ?>
    
    <script>
        var width = <?php echo $defaultDimenssion[applicationConstants::SCREEN_DESKTOP]['width']; ?>;
        var height = <?php echo $defaultDimenssion[applicationConstants::SCREEN_DESKTOP]['height']; ?>;
        var aspectRatio = <?php echo $defaultDimenssion[applicationConstants::SCREEN_DESKTOP]['width']; ?> /
            <?php echo $defaultDimenssion[applicationConstants::SCREEN_DESKTOP]['height']; ?>;
        $(document).on('change', '.display-js', function () {
            var screenDesktop = <?php echo applicationConstants::SCREEN_DESKTOP ?>;
            var screenIpad = <?php echo applicationConstants::SCREEN_IPAD ?>;

            if ($(this).val() == screenDesktop) {
                width = <?php echo $defaultDimenssion[applicationConstants::SCREEN_DESKTOP]['width']; ?>;
                height = <?php echo $defaultDimenssion[applicationConstants::SCREEN_DESKTOP]['height']; ?>;
            } else if ($(this).val() == screenIpad) {
                width = <?php echo $defaultDimenssion[applicationConstants::SCREEN_IPAD]['width']; ?>;
                height = <?php echo $defaultDimenssion[applicationConstants::SCREEN_IPAD]['height']; ?>;
            } else {
                width = <?php echo $defaultDimenssion[applicationConstants::SCREEN_MOBILE]['width']; ?>;
                height = <?php echo $defaultDimenssion[applicationConstants::SCREEN_MOBILE]['height']; ?>;
            }

            $('.uploadimage--info').html(langLbl.preferredDimensions + ' ' + width + ' * ' + height);
            $('input[name=banner_min_width]').val(width);
            $('input[name=banner_min_height]').val(height);
        });
        $("document").ready(function () {
            $(".display-js").trigger('change');
        });
    </script>

</div>
<br>
<div id="image-listing"></div>
<?php
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>