<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$arr_flds = array(
    'select_all' => Labels::getLabel('LBL_Select_all', $adminLangId),
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    'afcommsetting_prodcat_id' => Labels::getLabel('LBL_Category', $adminLangId),
    'afcommsetting_user_id' => Labels::getLabel('LBL_Affiliate', $adminLangId),
    'afcommsetting_fees' => Labels::getLabel('LBL_Fees_[%]', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);

if (!$canEdit || empty($arr_listing)) {
    unset($arr_flds['select_all']);
}

$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $key => $val) {
    if ('select_all' == $key) {
        $th->appendElement('th')->appendElement('plaintext', array(), '<label class="checkbox"><input title="' . $val . '" type="checkbox" onclick="selectAll( $(this) )" class="selectAll-js"></label>', true);
    } else {
        $e = $th->appendElement('th', array(), $val);
    }
}

$sr_no = $page == 1 ? 0 : $pageSize * ($page - 1);
foreach ($arr_listing as $sn => $row) {
    $sr_no++;
    $tr = $tbl->appendElement('tr');

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'select_all':
                if (1 > $row['afcommsetting_is_mandatory']) {
                    $td->appendElement('plaintext', array(), '<label class="checkbox"><input class="selectItem--js" type="checkbox" name="afcommsetting_ids[]" value=' . $row['afcommsetting_id'] . '></label>', true);
                }
                break;
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'afcommsetting_prodcat_id':
                $td->appendElement('plaintext', array(), CommonHelper::displayText($row['prodcat_name']), true);
                break;
            case 'afcommsetting_user_id':
                $td->appendElement('plaintext', array(), CommonHelper::displayText($row['credential_username']), true);
                break;
                case 'action':

                    if ($canEdit) {
                        $actionArr = [
                            [
                                "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                                "onclick" => "affiliateCommissionForm(" . $row['afcommsetting_id'] . ")"
                            ],
                            [
                                "title" => Labels::getLabel('LBL_History', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#history'></use></svg>",
                                "onclick" => "viewHistory(" . $row['afcommsetting_id'] . ")",
                            ],
                      
                        ];
                        if ($row['afcommsetting_is_mandatory'] != 1) {
                            $actionArr[] = 
                            [
                                "title" => Labels::getLabel('LBL_Delete', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                                "onclick" => "deleteAffiliateCommission(" . $row['afcommsetting_id'] . ")",
                            ];
                        }
                        $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$row['afcommsetting_id']], false);
                    }
                   
                    break;
            default:
                $td->appendElement('plaintext', array(), CommonHelper::displayText($row[$key]), true);
                break;
        }
    }
}


$frm = new Form('frmAffCommListing', array('id' => 'frmAffCommListing'));
$frm->setFormTagAttribute('class', 'form web_form last_td_nowrap actionButtons-js');
$frm->setFormTagAttribute('onsubmit', 'formAction(this, reloadList ); return(false);');
$frm->setFormTagAttribute('action', UrlHelper::generateUrl('AffiliateCommission', 'deleteSelected'));
$frm->addHiddenField('', 'status');

echo $frm->getFormTag();
echo $frm->getFieldHtml('status');
echo $tbl->getHtml(); 
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</form>
<?php $postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmAffiliateCommissionSearchPaging'));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
