<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
<?php
$arr_flds = array(
	'user_name' => Labels::getLabel('LBL_Name', $adminLangId),
	'credential_email' => Labels::getLabel('LBL_Email', $adminLangId),
	'user_regdate' => Labels::getLabel('LBL_Reg._Date', $adminLangId),
	'totUserBalance' => Labels::getLabel('LBL_Balance', $adminLangId),
);

$tbl = new HtmlElement(
	'table',
	array('width' => '100%', 'class' => 'table table-hovered table-justified')
);

$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $val) {
	$e = $th->appendElement('th', array(), $val);
}

$sr_no = $page == 1 ? 0 : $pageSize * ($page - 1);
foreach ($arr_listing as $sn => $row) {
	$sr_no++;
	$tr = $tbl->appendElement('tr');

	foreach ($arr_flds as $key => $val) {
		$td = $tr->appendElement('td');
		switch ($key) {
			case 'listserial':
				$td->appendElement('plaintext', array(), $sr_no);
				break;
			case 'user_name':
				$td->appendElement('a', array('href' => 'javascript:void(0)', 'onClick' => 'redirectfunc("' . UrlHelper::generateUrl('Users') . '", ' . $row['user_id'] . ')'), $row['user_name'], true);
				break;
			case 'user_regdate':
				$date = FatDate::format($row[$key]);
				$dateHtml = "";
				if (strpos($date, ' ') !== false) {
					list($formattedDate, $formattedTime) = explode(' ', $date);
					$dateHtml = "<date class='date'>" . $formattedDate . " <time>" . $formattedTime . "</time></date>";
				} else {
					$dateHtml = "<date class='date'>" . $date . "</date>";
				}
				$td->appendElement('plaintext', array(), $dateHtml, true);
				break;

			case 'totUserBalance':
				$td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($row[$key], true, true));
				break;

			default:
				$td->appendElement('plaintext', array(), $row[$key], true);
				break;
		}
	}
}

echo $tbl->getHtml();
if (count($arr_listing) == 0) {
	$this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</div>
<?php
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array(
	'name' => 'frmAdvertisersReportSearchPaging'
));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
?>