<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$btnFld = $frmResetPassword->getField('btn_reset');
$btnFld->addFieldTagAttribute('class', 'btn btn-brand btn-submit btn-block');
?>


<div class="page-main">
    <div class="page-main-single">
        <div class="card login-card">
            <header class="card-head">
                <figure class="logo-wrap">
                    <?php
                    // $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_ADMIN_LOGO, 0, 0, $adminLangId, false);
                    // $aspectRatioArr = AttachedFile::getRatioTypeArray($adminLangId);
                    $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_FRONT_LOGO, 0, 0, $adminLangId, true);
                    $aspectRatioArr = AttachedFile::getRatioTypeArray($adminLangId, true);
                    $sizeType = 'CUSTOM';
                    if ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_RECTANGULAR) {
                        $sizeType = '16X9';
                    } elseif ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_SQUARE) {
                        $sizeType = '1X1';
                    }
                    $uploadedTime = AttachedFile::setTimeParam($fileData['afile_updated_at']);
                    $siteLogo = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('Image', 'siteLogo', array($adminLangId, $sizeType), CONF_WEBROOT_FRONT_URL) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
                    ?>
                    <img class="logo" <?php if ($fileData['afile_aspect_ratio'] > 0 && !empty($aspectRatioArr[$fileData['afile_aspect_ratio']])) { ?>
                            data-ratio="<?php echo $aspectRatioArr[$fileData['afile_aspect_ratio']]; ?>" <?php } ?>
                        src="<?php echo $siteLogo; ?>"
                        alt="">
                </figure>
                <div class="title">
                    <h2><?php echo Labels::getLabel('LBL_Reset_Password', CommonHelper::getLangId()); ?> </h2>
                    <!--<p><?php echo Labels::getLabel('LBL_Enter_The_E-mail_Address_Associated_With_Your_Account', $adminLangId) ?></p>-->
                </div>
            </header>
            <div class="card-body">
                <?php echo $frmResetPassword->getFormTag(); ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <?php echo $frmResetPassword->getFieldHTML('new_pwd'); ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <div class="captcha-wrap">
                                <?php echo $frmResetPassword->getFieldHTML('confirm_pwd'); ?>
                                <?php echo $frmResetPassword->getFieldHTML('apr_id'); ?>
                                <?php echo $frmResetPassword->getFieldHTML('token'); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <?php echo $frmResetPassword->getFieldHTML('btn_reset'); ?>
                        </div>
                    </div>
                </div>

                <?php echo $frmResetPassword->getExternalJS(); ?>
                </form>
            </div>
            <div class="card-foot">
                <p>
                    <a class="link-underline" href="<?php echo UrlHelper::generateUrl('adminGuest', 'loginForm'); ?>">
                        <?php echo Labels::getLabel('LBL_Back_to_Login', $adminLangId); ?>
                    </a>
                </p>
            </div>
        </div>
        <?php include_once(CONF_THEME_PATH . 'default/_partial/copyright.php'); ?>
    </div>