<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php $userNameFld = $frm->getField('username');
$userNameFld->addFieldTagAttribute('placeholder', Labels::getlabel('LBL_Username', $adminLangId));
$passwordFld = $frm->getField('password');
$passwordFld->addFieldTagAttribute('placeholder', Labels::getlabel('LBL_Password', $adminLangId));
$passwordFld->addFieldTagAttribute('id', 'password');
$rememberMeFld = $frm->getField('rememberme');
//$rememberMeFld->fieldWrapper = array('<label class="switch switch-sm switch-icon">', '</label>');
$rememberMeFld->addFieldTagAttribute('class', 'switch-labels');
$btnFld = $frm->getField('btn_submit');
$btnFld->addFieldTagAttribute('class', 'btn btn-brand btn-submit btn-block');
?>
<div class="page-main">
    <div class="page-main-single">
        <div class="card login-card">
            <header class="card-head">
                <figure class="logo-wrap">
                    <?php
                    // $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_ADMIN_LOGO, 0, 0, $adminLangId, false);
                    // $aspectRatioArr = AttachedFile::getRatioTypeArray($adminLangId);
                    $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_FRONT_LOGO, 0, 0, $adminLangId, true);
                    $aspectRatioArr = AttachedFile::getRatioTypeArray($adminLangId, true);
                    $sizeType = 'CUSTOM';
                    if ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_RECTANGULAR) {
                        $sizeType = '16X9';
                    } elseif ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_SQUARE) {
                        $sizeType = '1X1';
                    }

                    $uploadedTime = AttachedFile::setTimeParam($fileData['afile_updated_at']);
                    $siteLogo = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('Image', 'siteLogo', array($adminLangId, $sizeType), CONF_WEBROOT_FRONT_URL) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
                    ?>
                    <img class="logo" <?php if ($fileData['afile_aspect_ratio'] > 0 && !empty($aspectRatioArr[$fileData['afile_aspect_ratio']])) { ?>
                            data-ratio="<?php echo $aspectRatioArr[$fileData['afile_aspect_ratio']]; ?>" <?php } ?>
                        title="<?php echo FatApp::getConfig("CONF_WEBSITE_NAME_" . $adminLangId); ?>"
                        src="<?php echo $siteLogo; ?>"
                        alt="<?php echo FatApp::getConfig("CONF_WEBSITE_NAME_" . $adminLangId); ?>">
                </figure>
            </header>
            <div class="card-body">
                <div class="title">
                    <h2><?php echo Labels::getLabel('LBL_SIGN_IN', $adminLangId); ?></h2>
                    <p><?php echo Labels::getLabel('LBL_PLEASE_ENTER_YOUR_LOGIN_CREDENTIALS', $adminLangId); ?></p>
                </div>
                <?php echo $frm->getFormTag(); ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="label"><?php echo Labels::getlabel('LBL_Username', $adminLangId) ?></label>
                            <?php echo $frm->getFieldHTML('username'); ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group form-group-relative">
                            <label class="label"><?php echo Labels::getlabel('LBL_Password', $adminLangId) ?></label>
                            <?php echo $frm->getFieldHTML('password'); ?>
                            <span class="field-password " id="showPass"></span>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <?php $remeberfld = $frm->getFieldHTML('rememberme');
                            //  $remeberfld = str_replace("label", "label class='switch switch-sm switch-icon'", $remeberfld);
                            echo $remeberfld;
                            ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <?php echo $frm->getFieldHTML('btn_submit'); ?>
                        </div>
                    </div>
                </div>
                <?php echo $frm->getExternalJS(); ?>
                </form>
            </div>
            <div class="card-foot">
                <p>
                    <a class="link-brand link-underline"
                        href="<?php echo UrlHelper::generateUrl('adminGuest', 'forgotPasswordForm'); ?>"><?php echo Labels::getLabel('LBL_Forgot_Password?', $adminLangId); ?>
                    </a>
                </p>

            </div>
        </div>
        <?php include_once(CONF_THEME_PATH . 'default/_partial/copyright.php'); ?>
    </div>
</div>