<?php
defined('SYSTEM_INIT') or die('Invalid Usage');
$pagination = '';

if ($pageCount < 1) {
    return $pagination;
}

/*Number of links to display*/
$linksToDisp = isset($linksToDisp) ? $linksToDisp : 2;

/* Current page number */
$pageNumber = $page;

/*arguments mixed(array/string(comma separated)) // function arguments*/
$arguments = (isset($arguments)) ? $arguments : null;

$pageSize = (isset($pageSize)) ? $pageSize : FatApp::getConfig('CONF_ADMIN_PAGESIZE', FatUtility::VAR_INT, 10);

/*padArgListTo boolean(T/F) // where to pad argument list (left/right) */
$padArgToLeft = (isset($padArgToLeft)) ? $padArgToLeft : true;

/*On clicking page link which js function need to call*/
$callBackJsFunc = isset($callBackJsFunc) ? $callBackJsFunc : 'goToSearchPage';


if (null != $arguments) {
    if (is_array($arguments)) {
        $args = implode(', ', $arguments);
    } elseif (is_string($arguments)) {
        $args = $arguments;
    }
    if ($padArgToLeft) {
        $callBackJsFunc = $callBackJsFunc . '(' . $args . ', xxpagexx);';
    } else {
        $callBackJsFunc = $callBackJsFunc . '(xxpagexx, ' . $args . ');';
    }
} else {
    $callBackJsFunc = $callBackJsFunc . '(xxpagexx);';
}

$pagination .= FatUtility::getPageString(
    '<li class="pagination-item"><a class="pagination-link" href="javascript:void(0);" onclick="' . $callBackJsFunc . '">xxpagexx</a></li>',
    $pageCount,
    $pageNumber,
    ' <li class="pagination-item selected"><a class="pagination-link" href="javascript:void(0);">xxpagexx</a></li>',
    ' <li class="pagination-item"><a class="pagination-link" href="javascript:void(0);">...</a></li> ',
    $linksToDisp,
    ' <li class="pagination-item"><a class="pagination-link"  href="javascript:void(0);" onclick="' . $callBackJsFunc . '"><svg class="svg" width="12" height="12" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M4.83582 12L11.0429 18.2071L12.4571 16.7929L7.66424 12L12.4571 7.20712L11.0429 5.79291L4.83582 12ZM10.4857 12L16.6928 18.2071L18.107 16.7929L13.3141 12L18.107 7.20712L16.6928 5.79291L10.4857 12Z"></path></svg></a></li>',
    ' <li class="pagination-item"><a class="pagination-link" href="javascript:void(0);" onclick="' . $callBackJsFunc . '"><svg class="svg" width="12" height="12" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M19.1642 12L12.9571 5.79291L11.5429 7.20712L16.3358 12L11.5429 16.7929L12.9571 18.2071L19.1642 12ZM13.5143 12L7.30722 5.79291L5.89301 7.20712L10.6859 12L5.89301 16.7929L7.30722 18.2071L13.5143 12Z"></path></svg></a></li>',
    ' <li class="pagination-item"><a class="pagination-link" href="javascript:void(0);" onclick="' . $callBackJsFunc . '"><svg class="svg" width="12" height="12" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M10.8284 12.0007L15.7782 16.9504L14.364 18.3646L8 12.0007L14.364 5.63672L15.7782 7.05093L10.8284 12.0007Z"></path></svg></a></li>',
    ' <li class="pagination-item"><a class="pagination-link" href="javascript:void(0);" onclick="' . $callBackJsFunc . '"><svg class="svg" width="12" height="12" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M13.1717 12.0007L8.22192 7.05093L9.63614 5.63672L16.0001 12.0007L9.63614 18.3646L8.22192 16.9504L13.1717 12.0007Z"></path></svg></a></li>'
);

$ul = new HtmlElement(
    'ul',
    array(
        'class' => 'pagination',
    ),
    $pagination,
    true
);
?>
<div class="card-foot pagers">
    <div class="row justify-content-between align-items-center">
        <div class="col">
            <?php if ($pageCount == 1) { ?>
                <div class="showing"><?php echo Labels::getLabel('LBL_Showing', $adminLangId); ?>
                    <?php echo $recordCount; ?>
                    <?php echo Labels::getLabel('LBL_Entries', $adminLangId); ?>
                </div>
            <?php } else { ?>
                <div class="showing"><?php echo Labels::getLabel('LBL_Showing', $adminLangId); ?>
                    <?php echo $startIdx = ($pageNumber - 1) * $pageSize + 1; ?>
                    <?php echo Labels::getLabel('LBL_to', $adminLangId); ?>
                    <?php echo ($recordCount < $startIdx + $pageSize - 1) ? $recordCount : $startIdx + $pageSize - 1; ?>
                    <?php echo Labels::getLabel('LBL_of', $adminLangId); ?>     <?php echo $recordCount; ?>
                    <?php echo Labels::getLabel('LBL_Entries', $adminLangId); ?>
                </div>
            <?php } ?>
        </div>
        <?php
        if ($pageCount > 1) {
            ?>
            <div class="col-auto">
                <?php echo $ul->getHtml(); ?>
            </div>
            <?php
        }
        ?>

    </div>
</div> 

<script>
    
    function actionButtonDisabled(){
        var parentForm = $(this.form).attr("id");
   
        var faceboxActionBtns = 0 < $("#facebox").length && $("#facebox").is(":visible") ? "#facebox " : "";
        if ($(".selectItem--js:checked").length == 0) {
            $(faceboxActionBtns + " .toolbar-btn-js").addClass("disabled");
            $(".default-action--js").removeClass("disabled");
        } else {
            $(faceboxActionBtns + " .toolbar-btn-js").removeClass("disabled");
            $(".default-action--js").addClass("disabled");
        }
    }
    actionButtonDisabled();
</script>