<!--left panel start here-->
<sidebar class="sidebar">
    <div class="sidebar-head"> </div>
    <div class="sidebar-body sidebarMenuJs">
        <ul class="dashboard-menu">
            <?php if ($objPrivilege->canViewAdminDashboard(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                <li class="dashboard-menu-item">
                    <a class="dashboard-menu-btn" href="<?php echo UrlHelper::generateUrl(); ?>">
                        <span class="dashboard-menu-icon">
                            <svg class="svg" width="18" height="18">
                                <use xlink:href="/images/admin/retina/sprite-aside-menu.svg#icon-dashboard">
                                </use>
                            </svg>
                        </span>
                        <span class="dashboard-menu-head">
                            <?php echo Labels::getLabel('LBL_Dashboard', $adminLangId); ?>
                        </span>
                    </a>
                </li>
            <?php } ?>
            <?php if ($objPrivilege->canViewShops(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                <li class="dashboard-menu-item">
                    <a class="dashboard-menu-btn" href="<?php echo UrlHelper::generateUrl('Shops'); ?>">
                        <span class="dashboard-menu-icon">
                            <svg class="svg" width="18" height="18">
                                <use xlink:href="/images/admin/retina/sprite-aside-menu.svg#icon-shops">
                                </use>
                            </svg>
                        </span>
                        <span class="dashboard-menu-head">
                            <?php echo Labels::getLabel('LBL_Shops', $adminLangId); ?>
                    </a>
                </li>
            <?php } ?>
            <!--Products -->
            <?php
            if (
                $objPrivilege->canViewProductCategories(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewProducts(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewBrands(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewAttributes(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewOptions(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewTags(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewBrandRequests(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewSellerProducts(AdminAuthentication::getLoggedAdminId(), true)
            ) {
                ?>
                <li class="dashboard-menu-item haschild">
                    <button class="dashboard-menu-btn dropdown-toggle-custom collapsed" type="button"
                        data-bs-toggle="collapse" data-bs-target="#Catalog" aria-expanded="false" title="">
                        <span class="dashboard-menu-icon">
                            <svg class="svg" width="18" height="18">
                                <use xlink:href="/images/admin/retina/sprite-aside-menu.svg#icon-product-catalog">
                                </use>
                            </svg>
                        </span>
                        <span class="dashboard-menu-head ">
                            <?php echo Labels::getLabel('LBL_Catalog', $adminLangId); ?>
                        </span><i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
                    </button>
                    <ul class="menu-sub menu-sub-accordion collapse second-level-nav" id="Catalog" aria-labelledby=""
                        data-parent="#dashboard-menu">
                        <?php if ($objPrivilege->canViewBrands(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item">
                                <a class="menu-sub-link navLinkJs" href="<?php echo UrlHelper::generateUrl('Brands'); ?>">
                                    <span class="menu-sub-title">
                                        <?php echo Labels::getLabel('LBL_Brands', $adminLangId); ?></span></a>
                            </li>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewOptions(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item">
                                <a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('Options'); ?>"><?php echo Labels::getLabel('LBL_Options', $adminLangId); ?></a>
                            </li>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewProductCategories(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item">
                                <a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('ProductCategories'); ?>"><?php echo Labels::getLabel('LBL_Categories', $adminLangId); ?></a>
                            </li>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewProducts(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item">
                                <a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('products'); ?>"><?php echo Labels::getLabel('LBL_Products', $adminLangId); ?></a>
                            </li>
                            <?php if ($objPrivilege->canViewSellerProducts(AdminAuthentication::getLoggedAdminId(), true) && ALLOW_SALE) { ?>
                                <li class="menu-sub-item">
                                    <a class="menu-sub-link navLinkJs"
                                        href="<?php echo UrlHelper::generateUrl('SellerProducts', 'thresholdProducts'); ?>"><?php echo Labels::getLabel('LBL_Threshold_Products', $adminLangId); ?>
                                        <?php if ($threshSelProdCount) { ?><span
                                                class='badge'>(<?php echo $threshSelProdCount; ?>)</span><?php } ?></a>
                                </li>
                            <?php } ?>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewProducts(AdminAuthentication::getLoggedAdminId(), true) || (FatApp::getConfig("CONF_ENABLE_DOCUMENT_VERIFICATION", FatUtility::VAR_INT, 1) && $objPrivilege->canViewDocumentVerification(AdminAuthentication::getLoggedAdminId(), true))) { ?>
                            <li class="menu-sub-item haschild">
                                <button class="dashboard-menu-btn dropdown-toggle-custom collapsed" type="button"
                                    data-bs-toggle="collapse" data-bs-target="#Rental_Product_Options" aria-expanded="false"
                                    title="">
                                    <span class="dashboard-menu-head">
                                        <?php echo Labels::getLabel('LBL_Rental_Product_Options', $adminLangId); ?>
                                    </span>
                                    <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
                                </button>
                                <ul class="menu-sub menu-sub-accordion collapse third-level-nav" id="Rental_Product_Options" aria-labelledby=""
                                    data-parent="#dashboard-menu">
                                    <li class="menu-sub-item">
                                        <a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('sellerProducts', 'index'); ?>"><?php echo Labels::getLabel('LBL_Seller_Inventory', $adminLangId); ?></a>
                                    </li>

                                    <li class="menu-sub-item">
                                        <a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('AddonProducts', 'listing'); ?>"><?php echo Labels::getLabel('LBL_Rental_Addons', $adminLangId); ?></a>
                                    </li>
                                    <li class="menu-sub-item">
                                        <a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('AddonProducts'); ?>"><?php echo Labels::getLabel('LBL_Linked_Rental_Addons_To_Products', $adminLangId); ?></a>
                                    </li>

                                    <li class="menu-sub-item ">
                                        <a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('SellerRentalProducts', 'productRentalUnavailableDates'); ?>"><?php echo Labels::getLabel('LBL_Product_Unavailable_Dates', $adminLangId); ?></a>
                                    </li>

                                    <?php if (FatApp::getConfig("CONF_ENABLE_DOCUMENT_VERIFICATION", FatUtility::VAR_INT, 1) && $objPrivilege->canViewDocumentVerification(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                        <li class="menu-sub-item">
                                            <a class="menu-sub-link navLinkJs"
                                                href="<?php echo UrlHelper::generateUrl('VerificationFields'); ?>">
                                                <?php echo Labels::getLabel('LBL_Document_Verification_Fields', $adminLangId); ?>
                                            </a>
                                        </li>
                                    <?php } ?>

                                </ul>
                            </li>
                        <?php } ?>
                        <?php if (FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0) && $objPrivilege->canViewProducts(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item haschild">
                                <a class="dashboard-menu-btn dropdown-toggle-custom" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#Sale_Product_Options" aria-expanded="false" title="">
                                    <span class="dashboard-menu-head">
                                        <?php echo Labels::getLabel('LBL_Sale_Product_Options', $adminLangId); ?>
                                    </span>
                                    <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>

                                </a>
                                <ul class="menu-sub menu-sub-accordion collapse third-level-nav" id="Sale_Product_Options" aria-labelledby=""
                                    data-parent="#dashboard-menu">
                                    <li class="menu-sub-item">
                                        <a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('sellerProducts', 'sales'); ?>">
                                            <?php echo Labels::getLabel('LBL_Seller_Inventory', $adminLangId); ?></a>
                                    </li>
                                </ul>
                            </li>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewProducts(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item">
                                <a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('sellerProducts', 'relatedProducts'); ?>">
                                    <span class="dashboard-menu-title">
                                        <?php echo Labels::getLabel('LBL_Related_Products', $adminLangId); ?>
                                    </span>
                                </a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewProducts(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item">
                                <a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('sellerProducts', 'upsellProducts'); ?>">
                                    <span class="dashboard-menu-title">
                                        <?php echo Labels::getLabel('LBL_Buy_Together_Products', $adminLangId); ?>
                                    </span>
                                </a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewProductReviews(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item">
                                <a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('productReviews'); ?>">
                                    <span class="dashboard-menu-title">
                                        <?php echo Labels::getLabel('LBL_Product_Reviews', $adminLangId); ?>
                                    </span>
                                </a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewTags(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item">
                                <a class="menu-sub-link navLinkJs" href="<?php echo UrlHelper::generateUrl('Tags'); ?>">
                                    <span class="dashboard-menu-title">
                                        <?php echo Labels::getLabel('LBL_Tags', $adminLangId); ?>
                                    </span>
                                </a>
                            </li>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewBrandRequests(AdminAuthentication::getLoggedAdminId(), true) && FatApp::getConfig('CONF_BRAND_REQUEST_APPROVAL', FatUtility::VAR_INT, 0)) { ?>
                            <li class="menu-sub-item">
                                <a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('Brands', 'BrandRequests'); ?>">
                                    <span class="dashboard-menu-title">
                                        <?php echo Labels::getLabel('LBL_Brand_Requests', $adminLangId); ?>
                                        <?php if ($brandReqCount) { ?>
                                        </span>
                                        <span class='badge'>(<?php echo $brandReqCount; ?>)</span><?php } ?></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewProductCategories(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item">
                                <a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('ProductCategories', 'requests'); ?>">
                                    <span class="dashboard-menu-title">
                                        <?php echo Labels::getLabel('LBL_Categories_Requests', $adminLangId); ?>
                                        <?php if ($categoryReqCount) { ?>
                                        </span>
                                        <span class='badge'>(<?php echo $categoryReqCount; ?>)</span><?php } ?></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewCustomCatalogProductRequests(AdminAuthentication::getLoggedAdminId(), true) && (FatApp::getConfig('CONF_SELLER_CAN_REQUEST_CUSTOM_PRODUCT', FatUtility::VAR_INT, 0) || FatApp::getConfig('CONF_ENABLED_SELLER_CUSTOM_PRODUCT', FatUtility::VAR_INT, 0))) { ?>
                            <li class="menu-sub-item">
                                <a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('CustomProducts'); ?>">
                                    <span class="dashboard-menu-title">
                                        <?php echo Labels::getLabel('LBL_Custom_Product_Catalog_Requests', $adminLangId); ?>
                                        <?php if ($custProdReqCount) { ?>
                                        </span>

                                        <span class='badge'>(<?php echo $custProdReqCount; ?>)</span><?php } ?>
                                </a>
                            </li>
                        <?php } ?>
                    </ul>
                </li>
            <?php } ?>

            <?php
            if (
                $objPrivilege->canViewProducts(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewDiscountCoupons(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewRewardsOnPurchase(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewRecomendedWeightages(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewPromotions(AdminAuthentication::getLoggedAdminId(), true)
            ) {
                ?>
                <li class="dashboard-menu-item haschild">
                    <button class="dashboard-menu-btn dropdown-toggle-custom collapsed" type="button"
                        data-bs-toggle="collapse" data-bs-target="#nav-promotion" aria-expanded="false" title="">
                        <span class="dashboard-menu-icon">
                            <svg class="svg" width="18" height="18">
                                <use xlink:href="/images/admin/retina/sprite-aside-menu.svg#icon-promotions">
                                </use>
                            </svg>
                        </span>
                        <span class="dashboard-menu-head ">
                            <?php echo Labels::getLabel('LBL_Promotions', $adminLangId); ?>
                        </span>
                        <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
                    </button>
                    <ul class="menu-sub menu-sub-accordion collapse second-level-nav" id="nav-promotion">
                        <?php if ($objPrivilege->canViewProducts(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item haschild">
                                <button class="dashboard-menu-btn dropdown-toggle-custom" data-bs-toggle="collapse"
                                    data-bs-target="#nav-rental-promotion" aria-expanded="false" title="" type="button">
                                    <span class="dashboard-menu-head">
                                        <?php echo Labels::getLabel('LBL_Rental_Promotions', $adminLangId); ?> </span>
                                    <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>

                                </button>
                                <ul class="menu-sub menu-sub-accordion collapse third-level-nav" id="nav-rental-promotion">
                                    <li class="menu-sub-item">
                                        <a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('sellerProducts', 'rentalSpecialPrice'); ?>"><span
                                                class="menu-sub-title"><?php echo Labels::getLabel('LBL_Special_Price', $adminLangId); ?></span></a>
                                    </li>
                                    <?php /* <li class="menu-sub-item">
                                        <a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('SellerRentalProducts', 'sellerProductDurationDiscounts'); ?>"><span
                                                class="menu-sub-title"><?php echo Labels::getLabel('LBL_Duration_Discounts', $adminLangId); ?></span></a>
                                    </li> */ ?>

                                </ul>
                            </li>
                            <?php if (FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0)) { ?>
                                <li class="menu-sub-item haschild">
                                    <button class="dashboard-menu-btn dropdown-toggle-custom" data-bs-toggle="collapse"
                                        data-bs-target="#nav-sale-promotion" aria-expanded="false" title="" type="button">
                                        <span class="dashboard-menu-head">
                                            <?php echo Labels::getLabel('LBL_Sale_Promotions', $adminLangId); ?>
                                        </span>
                                        <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
                                    </button>
                                    <ul class="menu-sub menu-sub-accordion collapse third-level-nav" id="nav-sale-promotion">
                                        <li class="menu-sub-item">
                                            <a class="menu-sub-link navLinkJs"
                                                href="<?php echo UrlHelper::generateUrl('sellerProducts', 'specialPrice'); ?>">
                                                <span
                                                    class="menu-sub-title"><?php echo Labels::getLabel('LBL_Special_Price', $adminLangId); ?></span></a>
                                        </li>
                                        <li class="menu-sub-item">
                                            <a class="menu-sub-link navLinkJs"
                                                href="<?php echo UrlHelper::generateUrl('sellerProducts', 'volumeDiscount'); ?>">
                                                <span
                                                    class="menu-sub-title"><?php echo Labels::getLabel('LBL_Volume_Discount', $adminLangId); ?></span></a>
                                        </li>

                                    </ul>
                                </li>
                            <?php }
                        } ?>


                        <?php if ($objPrivilege->canViewDiscountCoupons(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('DiscountCoupons'); ?>">
                                    <span
                                        class="menu-sub-title"><?php echo Labels::getLabel('LBL_Discount_Coupons', $adminLangId); ?></span></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewPromotions(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('promotions'); ?>">
                                    <span
                                        class="menu-sub-title"><?php echo Labels::getLabel('LBL_PPC_Promotions_Management', $adminLangId); ?></span>
                                </a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewRewardsOnPurchase(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('RewardsOnPurchase'); ?>">
                                    <span
                                        class="menu-sub-title"><?php echo Labels::getLabel('LBL_Rewards_on_every_purchase', $adminLangId); ?></span></a>
                            </li>
                        <?php } ?>
                    </ul>
                </li>
            <?php } ?>

            <?php
            if (
                $objPrivilege->canViewOrders(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewSellerOrders(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewAbandonedCart(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewSubscriptionOrders(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewWithdrawRequests(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewOrderCancellationRequests(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewOrderReturnRequests(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewProductReviews(AdminAuthentication::getLoggedAdminId(), true) ||
                ($objPrivilege->canViewRentalOrderCancelRules(AdminAuthentication::getLoggedAdminId(), true) && FatApp::getConfig('CONF_ALLOW_PENALTY_ON_RENTAL_ORDER_CANCEL_FROM_BUYER', FatUtility::VAR_INT, 0))
            ) {
                ?>
                <li class="dashboard-menu-item haschild">
                    <button type="button" class="dashboard-menu-btn dropdown-toggle-custom collapsed"
                        data-bs-toggle="collapse" data-bs-target="#nav-orders" aria-expanded="false" title="">
                        <span class="dashboard-menu-icon">
                            <svg class="svg" width="18" height="18">
                                <use xlink:href="/images/admin/retina/sprite-aside-menu.svg#icon-orders">
                                </use>
                            </svg>
                        </span>
                        <span class="dashboard-menu-head ">
                            <?php echo Labels::getLabel('LBL_Orders', $adminLangId); ?> </span><i
                            class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>

                    </button>
                    <ul class="menu-sub menu-sub-accordion collapse second-level-nav" id="nav-orders">
                        <li class="menu-sub-item haschild">
                            <button class="dashboard-menu-btn dropdown-toggle-custom" data-bs-toggle="collapse"
                                data-bs-target="#nav-rental-orders" aria-expanded="false" title="" type="button">
                                <span class="dashboard-menu-head">
                                    <?php echo Labels::getLabel('LBL_Rental_Orders', $adminLangId); ?> </span>
                                <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
                            </button>
                            <ul class="menu-sub menu-sub-accordion collapse third-level-nav" id="nav-rental-orders">
                                <?php if ($objPrivilege->canViewOrders(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                    <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('orders', 'rental'); ?>"><?php echo Labels::getLabel('LBL_Orders', $adminLangId); ?></a>
                                    </li>
                                <?php } ?>
                                <?php if ($objPrivilege->canViewSellerOrders(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                    <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('SellerOrders', 'rental'); ?>"><?php echo Labels::getLabel('LBL_Seller_Orders', $adminLangId); ?>
                                            <?php if (!empty($sellerRentalOrderCount)) { ?><span
                                                    class='badge'>(<?php echo $sellerRentalOrderCount; ?>)</span><?php } ?></a>
                                    </li>

                                    <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('SellerOrders', 'lateChargesHistory'); ?>"><?php echo Labels::getLabel('LBL_Late_Charges_History', $adminLangId); ?></a>
                                    </li>
                                <?php } ?>
                                <?php if ($objPrivilege->canViewOrderCancellationRequests(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                    <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('OrderCancellationRequests', 'rental'); ?>"><?php echo Labels::getLabel('LBL_Cancellation_Requests', $adminLangId); ?>
                                            <?php if ($rentalOrderCancelReqCount) { ?><span
                                                    class='badge'>(<?php echo $rentalOrderCancelReqCount; ?>)</span><?php } ?></a>
                                    </li>

                                    <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('SellerOrders', 'cancelPenaltyHistory'); ?>"><?php echo Labels::getLabel('LBL_Cancel_Penalty_History', $adminLangId); ?></a>
                                    </li>
                                <?php } ?>
                                <?php if ($objPrivilege->canViewOrderReturnRequests(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                    <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('OrderReturnRequests', 'rental'); ?>"><?php echo Labels::getLabel('LBL_Return/Refund_Requests', $adminLangId); ?>
                                            <?php if ($rentalOrderRetReqCount) { ?><span
                                                    class='badge'>(<?php echo $rentalOrderRetReqCount; ?>)</span><?php } ?></a>
                                    </li>
                                <?php } ?>
                                <?php if ($objPrivilege->canViewRentalOrderCancelRules(AdminAuthentication::getLoggedAdminId(), true) && FatApp::getConfig('CONF_ALLOW_PENALTY_ON_RENTAL_ORDER_CANCEL_FROM_BUYER', FatUtility::VAR_INT, 0)) { ?>
                                    <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('orderCancelRules'); ?>"><?php echo Labels::getLabel('LBL_Order_Cancel_Rules', $adminLangId); ?></a>
                                    </li>
                                <?php } ?>
                            </ul>
                        </li>
                        <?php if (FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0)) { ?>
                            <li class="menu-sub-item haschild">
                                <button class="dashboard-menu-btn dropdown-toggle-custom" data-bs-toggle="collapse"
                                    data-bs-target="#nav-sale-orders" aria-expanded="false" title="" type="button">
                                    <span class="dashboard-menu-head">
                                        <?php echo Labels::getLabel('LBL_Sale_Orders', $adminLangId); ?> </span>
                                    <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
                                </button>
                                <ul class="menu-sub menu-sub-accordion collapse third-level-nav" id="nav-sale-orders">
                                    <?php if ($objPrivilege->canViewOrders(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                        <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                                href="<?php echo UrlHelper::generateUrl('orders'); ?>"><?php echo Labels::getLabel('LBL_Orders', $adminLangId); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if ($objPrivilege->canViewSellerOrders(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                        <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                                href="<?php echo UrlHelper::generateUrl('SellerOrders'); ?>"><?php echo Labels::getLabel('LBL_Seller_Orders', $adminLangId); ?>
                                                <?php if (!empty($sellerOrderCount)) { ?><span
                                                        class='badge'>(<?php echo $sellerOrderCount; ?>)</span><?php } ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if ($objPrivilege->canViewOrderCancellationRequests(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                        <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                                href="<?php echo UrlHelper::generateUrl('OrderCancellationRequests'); ?>"><?php echo Labels::getLabel('LBL_Cancellation_Requests', $adminLangId); ?>
                                                <?php if ($orderCancelReqCount) { ?><span
                                                        class='badge'>(<?php echo $orderCancelReqCount; ?>)</span><?php } ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if ($objPrivilege->canViewOrderReturnRequests(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                        <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                                href="<?php echo UrlHelper::generateUrl('OrderReturnRequests'); ?>"><?php echo Labels::getLabel('LBL_Return/Refund_Requests', $adminLangId); ?>
                                                <?php if ($orderRetReqCount) { ?><span
                                                        class='badge'>(<?php echo $orderRetReqCount; ?>)</span><?php } ?></a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </li>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewSubscriptionOrders(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('SubscriptionOrders'); ?>"><?php echo Labels::getLabel('LBL_Subscription_Orders', $adminLangId); ?>
                                </a></li>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewWithdrawRequests(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('WithdrawalRequests'); ?>"><?php echo Labels::getLabel('LBL_Withdrawl_Requests', $adminLangId); ?>
                                    <?php if ($drReqCount) { ?><span
                                            class='badge'>(<?php echo $drReqCount; ?>)</span><?php } ?></a>
                            </li>
                        <?php } ?>
                    </ul>
                </li>
            <?php } ?>

            <?php if ($objPrivilege->canViewRfqManagement(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                <li class="dashboard-menu-item haschild"><a type="button"
                        class="dashboard-menu-btn dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                        data-bs-target="#nav-rfq" aria-expanded="false" title="">

                        <span class="dashboard-menu-icon">
                            <svg class="svg" width="18" height="18">
                                <use xlink:href="/images/admin/retina/sprite-aside-menu.svg#icon-rfq">
                                </use>
                            </svg>
                        </span>
                        <span class="dashboard-menu-head "><?php echo Labels::getLabel('LBL_RFQ', $adminLangId); ?></span><i
                            class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>

                    </a>
                    <ul class="menu-sub menu-sub-accordion collapse second-level-nav" id="nav-rfq">
                        <?php if ($objPrivilege->canViewRfqManagement(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo CommonHelper::generateUrl('RequestForQuotes'); ?>">
                                    <?php echo Labels::getLabel('LBL_RFQ_Management', $adminLangId); ?>
                                </a></li>
                        <?php } ?>

                    </ul>
                </li>
            <?php } ?>

            <?php
            if (
                $objPrivilege->canViewUsers(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewSellerApprovalForm(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewSellerApprovalRequests(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewSellerCatalogRequests(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewUserRequests(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewCustomCatalogProductRequests(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewAdminUsers(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewMessages(AdminAuthentication::getLoggedAdminId(), true)
            ) {
                ?>
                <li class="dashboard-menu-item haschild">
                    <button type="button" class="dashboard-menu-btn dropdown-toggle-custom collapsed"
                        data-bs-toggle="collapse" data-bs-target="#nav-users" aria-expanded="false" title="">

                        <span class="dashboard-menu-icon">
                            <svg class="svg" width="18" height="18">
                                <use xlink:href="/images/admin/retina/sprite-aside-menu.svg#icon-users">
                                </use>
                            </svg>
                        </span>
                        <span class="dashboard-menu-head ">
                            <?php echo Labels::getLabel('LBL_Users', $adminLangId); ?> </span><i
                            class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
                    </button>
                    <ul class="menu-sub menu-sub-accordion collapse second-level-nav" id="nav-users">
                        <?php if ($objPrivilege->canViewUsers(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('Users'); ?>"><?php echo Labels::getLabel('LBL_Users', $adminLangId); ?></a>
                            </li>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewAdminUsers(AdminAuthentication::getLoggedAdminId(), true) || $objPrivilege->canViewAdminUsers(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('AdminUsers') ?>"><?php echo Labels::getLabel('LBL_Admin_Sub_Users', $adminLangId); ?></a>
                            </li>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewMessages(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('Messages'); ?>"><?php echo Labels::getLabel('LBL_Messages', $adminLangId); ?></a>
                            </li>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewSellerApprovalForm(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('Users', 'sellerForm'); ?>"><?php echo Labels::getLabel('LBL_Seller_Approval_Form', $adminLangId); ?></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewSellerApprovalRequests(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('Users', 'sellerApprovalRequests'); ?>"><?php echo Labels::getLabel('LBL_Seller_Approval_Requests', $adminLangId); ?>
                                    <?php if ($supReqCount) { ?><span
                                            class='badge'>(<?php echo $supReqCount; ?>)</span><?php } ?></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewUserRequests(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('userGdprRequests'); ?>"><?php echo Labels::getLabel('LBL_Users_GDPR_Requests', $adminLangId); ?>
                                    <?php if ($gdprReqCount) { ?><span
                                            class='badge'>(<?php echo $gdprReqCount; ?>)</span><?php } ?></a>
                            </li>
                        <?php } ?>
                    </ul>
                </li>
            <?php } ?>
            <!--Mobile Application-->
            <?php
            if (
                $objPrivilege->canViewSalesReport(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewUsersReport(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewProductsReport(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewCatalogReport(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewShopsReport(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewTaxReport(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewCommissionReport(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewPerformanceReport(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewAdvertisersReport(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewRentalsReport(AdminAuthentication::getLoggedAdminId(), true)
            ) {
                ?>
                <li class="dashboard-menu-item haschild">
                    <button type="button" class="dashboard-menu-btn dropdown-toggle-custom collapsed"
                        data-bs-toggle="collapse" data-bs-target="#nav-reports" aria-expanded="false" title="">
                        <span class="dashboard-menu-icon">
                            <svg class="svg" width="18" height="18">
                                <use xlink:href="/images/admin/retina/sprite-aside-menu.svg#icon-reports">
                                </use>
                            </svg>
                        </span>
                        <span class="dashboard-menu-head ">
                            <?php echo Labels::getLabel('LBL_Reports', $adminLangId); ?> </span><i
                            class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
                    </button>

                    <ul class="menu-sub menu-sub-accordion collapse " id="nav-reports">
                        <li class="menu-sub-item haschild">

                            <button class="dashboard-menu-btn dropdown-toggle-custom" data-bs-toggle="collapse"
                                data-bs-target="#nav-rental-report" aria-expanded="false" title="" type="button">
                                <span class="dashboard-menu-head">
                                    <?php echo Labels::getLabel('LBL_Rental_Reports', $adminLangId); ?> </span>
                                <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
                            </button>


                            <ul class="menu-sub menu-sub-accordion collapse third-level-nav" id="nav-rental-report">
                                <?php if ($objPrivilege->canViewUsersReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                    <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('UsersReport', 'rental'); ?>"><?php echo Labels::getLabel('LBL_Buyers/Sellers', $adminLangId); ?></a>
                                    </li>
                                <?php } ?>
                                <?php if ($objPrivilege->canViewRentalsReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                    <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                            href="<?php echo CommonHelper::generateUrl('RentalsReport'); ?>"><?php echo Labels::getLabel('LBL_Sales', $adminLangId); ?></a>
                                    </li>
                                <?php } ?>
                                <?php if ($objPrivilege->canViewProductsReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                    <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('ProductsReport', 'rental'); ?>"><?php echo Labels::getLabel('LBL_Seller_Products', $adminLangId); ?></a>
                                    </li>
                                <?php } ?>
                                <?php if ($objPrivilege->canViewCatalogReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                    <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('CatalogReport', 'rental'); ?>"><?php echo Labels::getLabel('LBL_Catalog', $adminLangId); ?></a>
                                    </li>
                                <?php } ?>
                                <?php if ($objPrivilege->canViewShopsReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                    <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('ShopsReport', 'rental'); ?>"><?php echo Labels::getLabel('LBL_Shops', $adminLangId); ?></a>
                                    </li>
                                <?php } ?>
                                <?php if ($objPrivilege->canViewCommissionReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                    <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('CommissionReport', 'rental'); ?>"><?php echo Labels::getLabel('LBL_Commission', $adminLangId); ?></a>
                                    </li>
                                <?php } ?>
                                <?php if ($objPrivilege->canViewPerformanceReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                    <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('TopProductsReport', 'rental'); ?>"><?php echo Labels::getLabel('LBL_Top_Products', $adminLangId); ?></a>
                                    </li>
                                <?php } ?>
                                <?php if ($objPrivilege->canViewPerformanceReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                    <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('BadProductsReport', 'rental'); ?>"><?php echo Labels::getLabel('LBL_Most_Refunded_Products', $adminLangId); ?></a>
                                    </li>
                                <?php } ?>
                                <?php if ($objPrivilege->canViewPerformanceReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                    <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('CategoriesReport', 'rental'); ?>"><?php echo Labels::getLabel('LBL_Categories_Report', $adminLangId); ?></a>
                                    </li>
                                <?php } ?>
                                <?php if ($objPrivilege->canViewTaxReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                    <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                            href="<?php echo UrlHelper::generateUrl('TaxReport', 'rental'); ?>"><?php echo Labels::getLabel('LBL_Tax', $adminLangId); ?></a>
                                    </li>
                                <?php } ?>
                            </ul>
                        </li>

                        <?php if (FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0)) { ?>
                            <li class="menu-sub-item haschild">
                                <button class="dashboard-menu-btn dropdown-toggle-custom" data-bs-toggle="collapse"
                                    data-bs-target="#nav-sale-report" aria-expanded="false" title="" type="button">
                                    <span class="dashboard-menu-head">
                                        <?php echo Labels::getLabel('LBL_Sale_Reports', $adminLangId); ?> </span>
                                    <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
                                </button>
                                <ul class="menu-sub menu-sub-accordion collapse second-level-nav" id="nav-sale-report">
                                    <?php if ($objPrivilege->canViewUsersReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                        <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                                href="<?php echo UrlHelper::generateUrl('UsersReport'); ?>"><?php echo Labels::getLabel('LBL_Buyers/Sellers', $adminLangId); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if ($objPrivilege->canViewSalesReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                        <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                                href="<?php echo UrlHelper::generateUrl('SalesReport'); ?>"><?php echo Labels::getLabel('LBL_Sales', $adminLangId); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if ($objPrivilege->canViewProductsReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                        <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                                href="<?php echo UrlHelper::generateUrl('ProductsReport'); ?>"><?php echo Labels::getLabel('LBL_Seller_Products', $adminLangId); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if ($objPrivilege->canViewCatalogReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                        <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                                href="<?php echo UrlHelper::generateUrl('CatalogReport'); ?>"><?php echo Labels::getLabel('LBL_Catalog', $adminLangId); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if ($objPrivilege->canViewShopsReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                        <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                                href="<?php echo UrlHelper::generateUrl('ShopsReport'); ?>"><?php echo Labels::getLabel('LBL_Shops', $adminLangId); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if ($objPrivilege->canViewCommissionReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                        <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                                href="<?php echo UrlHelper::generateUrl('CommissionReport'); ?>"><?php echo Labels::getLabel('LBL_Commission', $adminLangId); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if ($objPrivilege->canViewPerformanceReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                        <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                                href="<?php echo UrlHelper::generateUrl('TopProductsReport'); ?>"><?php echo Labels::getLabel('LBL_Top_Products', $adminLangId); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if ($objPrivilege->canViewPerformanceReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                        <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                                href="<?php echo UrlHelper::generateUrl('BadProductsReport'); ?>"><?php echo Labels::getLabel('LBL_Most_Refunded_Products', $adminLangId); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if ($objPrivilege->canViewPerformanceReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                        <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                                href="<?php echo UrlHelper::generateUrl('CategoriesReport'); ?>"><?php echo Labels::getLabel('LBL_Categories_Report', $adminLangId); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if ($objPrivilege->canViewTaxReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                        <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                                href="<?php echo UrlHelper::generateUrl('TaxReport'); ?>"><?php echo Labels::getLabel('LBL_Tax', $adminLangId); ?></a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </li>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewAdvertisersReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('AdvertisersReport'); ?>"><?php echo Labels::getLabel('LBL_Advertisers', $adminLangId); ?></a>
                            </li>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewDiscountCoupons(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('DiscountCouponsReport'); ?>"><?php echo Labels::getLabel('LBL_Discount_Coupons', $adminLangId); ?></a>
                            </li>
                        <?php } ?>
                    </ul>
                </li>

            <?php } ?>

            <!--CMS-->
            <?php
            if (
                $objPrivilege->canViewContentPages(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewContentBlocks(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewNavigationManagement(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewZones(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewCountries(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewStates(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewCollections(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewPolicyPoints(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewEmptyCartItems(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewSocialPlatforms(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewShopReportReasons(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewOrderCancelReasons(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewOrderReturnReasons(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewTestimonial(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewDiscountCoupons(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewSellerDiscountCoupons(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewImportInstructions(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewEmailTemplates(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewSmsTemplate(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewOrderStatus(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewFaqCategories(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewAbusiveWords(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewContentWithIconSection(AdminAuthentication::getLoggedAdminId(), true)
            ) {
                ?>
                <li class="dashboard-menu-item haschild"><button type="button"
                        class="dashboard-menu-btn dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                        data-bs-target="#nav-cms" aria-expanded="false" title="">

                        <span class="dashboard-menu-icon">
                            <svg class="svg" width="18" height="18">
                                <use xlink:href="/images/admin/retina/sprite-aside-menu.svg#icon-CMS">
                                </use>
                            </svg>
                        </span>
                        <span class="dashboard-menu-head ">
                            <?php echo Labels::getLabel('LBL_Cms', $adminLangId); ?> </span><i
                            class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>

                    </button>
                    <ul id="nav-cms" class="menu-sub menu-sub-accordion collapse second-level-nav">
                        <?php if ($objPrivilege->canViewNavigationManagement(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('Navigations'); ?>"><?php echo Labels::getLabel('LBL_Navigation_Management', $adminLangId); ?></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewSlides(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('slides'); ?>"><?php echo Labels::getLabel('LBL_Home_Page_Slides_Management', $adminLangId); ?></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewCollections(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('Collections'); ?>"><?php echo Labels::getLabel('LBL_Collection_Management', $adminLangId); ?>
                                </a></li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewBanners(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('Banners'); ?>"><?php echo Labels::getLabel('LBL_Banners', $adminLangId); ?></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewLanguageLabels(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('Labels'); ?>"><?php echo Labels::getLabel('LBL_Language_Labels', $adminLangId); ?></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewEmailTemplates(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('EmailTemplates'); ?>"><?php echo Labels::getLabel('LBL_Email_Templates_Management', $adminLangId); ?></a>
                            </li>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewSmsTemplate(AdminAuthentication::getLoggedAdminId(), true) && SmsArchive::canSendSms()) { ?>
                            <li class="menu-sub-item">
                                <a class="menu-sub-link navLinkJs" href="<?php echo UrlHelper::generateUrl('SmsTemplates'); ?>">
                                    <?php echo Labels::getLabel('LBL_SMS_TEMPLATE_MANAGEMENT', $adminLangId); ?>
                                </a>
                            </li>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewContentPages(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('ContentPages'); ?>"><?php echo Labels::getLabel('LBL_Content_Pages', $adminLangId); ?></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewContentBlocks(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('ContentBlock'); ?>"><?php echo Labels::getLabel('LBL_Content_Blocks', $adminLangId); ?></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewImportInstructions(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('ContentBlock', 'importInstructions'); ?>"><?php echo Labels::getLabel('LBL_Import_Instructions', $adminLangId); ?></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewFaqCategories(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('FaqCategories'); ?>"><?php echo Labels::getLabel('LBL_FAQs', $adminLangId); ?></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewZones(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('Zones'); ?>"><?php echo Labels::getLabel('LBL_Zone(Regions)_Management', $adminLangId); ?></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewCountries(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('Countries'); ?>"><?php echo Labels::getLabel('LBL_Countries_Management', $adminLangId); ?></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewStates(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('States'); ?>"><?php echo Labels::getLabel('LBL_States_Management', $adminLangId); ?></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewEmptyCartItems(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('emptyCartItems'); ?>"><?php echo Labels::getLabel('LBL_Empty_Cart_Items_Management', $adminLangId); ?></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewSocialPlatforms(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('SocialPlatform'); ?>"><?php echo Labels::getLabel('LBL_Social_Platforms_Management', $adminLangId); ?></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewShopReportReasons(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('ShopReportReasons'); ?>"><?php echo Labels::getLabel('LBL_Shop_Report_Reasons_Management', $adminLangId); ?></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewOrderStatus(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('OrderStatus'); ?>"><?php echo Labels::getLabel('LBL_Order_Status_Management', $adminLangId); ?></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewOrderCancelReasons(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('OrderCancelReasons'); ?>"><?php echo Labels::getLabel('LBL_Order_Cancel_Reasons_Management', $adminLangId); ?>
                                </a></li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewOrderReturnReasons(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('OrderReturnReasons'); ?>"><?php echo Labels::getLabel('LBL_Order_Return_Reasons_Management', $adminLangId); ?>
                                </a></li>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewAbusiveWords(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('AbusiveWords'); ?>"><?php echo Labels::getLabel('LBL_Abusive_Keyword', $adminLangId); ?></a>
                            </li>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewTestimonial(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('Testimonials'); ?>"><?php echo Labels::getLabel('LBL_Testimonials_Management', $adminLangId); ?>
                                </a></li>
                        <?php } ?>

                    </ul>
                </li>
            <?php } ?>

            <?php
            if (
                $objPrivilege->canViewBlogPostCategories(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewBlogPosts(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewBlogContributions(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewBlogComments(AdminAuthentication::getLoggedAdminId(), true)
            ) {
                ?>
                <li class="dashboard-menu-item haschild"><button type="button"
                        class="dashboard-menu-btn dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                        data-bs-target="#nav-blog" aria-expanded="false" title="">

                        <span class="dashboard-menu-icon">
                            <svg class="svg" width="18" height="18">
                                <use xlink:href="/images/admin/retina/sprite-aside-menu.svg#icon-blog">
                                </use>
                            </svg>
                        </span>
                        <span class="dashboard-menu-head ">
                            <?php echo Labels::getLabel('LBL_Blog', $adminLangId); ?> </span><i
                            class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
                    </button>
                    <ul class="menu-sub menu-sub-accordion collapse second-level-nav" id="nav-blog">
                        <?php if ($objPrivilege->canViewBlogPostCategories(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('BlogPostCategories'); ?>"><?php echo Labels::getLabel('LBL_Blog_Post_Categories', $adminLangId); ?></a>
                            </li>
                            <?php
                        }
                        if ($objPrivilege->canViewBlogPosts(AdminAuthentication::getLoggedAdminId(), true)) {
                            ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('BlogPosts'); ?>"><?php echo Labels::getLabel('LBL_Blog_Posts', $adminLangId); ?></a>
                            </li>
                            <?php
                        }
                        if ($objPrivilege->canViewBlogContributions(AdminAuthentication::getLoggedAdminId(), true)) {
                            ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('BlogContributions'); ?>"><?php echo Labels::getLabel('LBL_Blog_Contributions', $adminLangId); ?>
                                    <?php if ($blogContrCount) { ?><span
                                            class='badge'>(<?php echo $blogContrCount; ?>)</span><?php } ?></a>
                            </li>
                            <?php
                        }
                        if ($objPrivilege->canViewBlogComments(AdminAuthentication::getLoggedAdminId(), true)) {
                            ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('BlogComments'); ?>"><?php echo Labels::getLabel('LBL_Blog_Comments', $adminLangId); ?>
                                    <?php if ($blogCommentsCount) { ?><span
                                            class='badge'>(<?php echo $blogCommentsCount; ?>)</span><?php } ?></a>
                            </li>
                        <?php } ?>
                    </ul>
                </li>
            <?php } ?>

            <?php
            if (
                $objPrivilege->canViewMetaTags(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewUrlRewrite(AdminAuthentication::getLoggedAdminId(), true)
            ) {
                ?>
                <li class="dashboard-menu-item haschild"><button type="button"
                        class="dashboard-menu-btn dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                        data-bs-target="#nav-seo" aria-expanded="false" title="">
                        <span class="dashboard-menu-icon">
                            <svg class="svg" width="18" height="18">
                                <use xlink:href="/images/admin/retina/sprite-aside-menu.svg#icon-SEO">
                                </use>
                            </svg>
                        </span>
                        <span class="dashboard-menu-head "><?php echo Labels::getLabel('LBL_SEO', $adminLangId); ?></span><i
                            class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
                    </button>
                    <ul class="menu-sub menu-sub-accordion collapse second-level-nav" id="nav-seo">
                        <?php if ($objPrivilege->canViewMetaTags(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('MetaTags'); ?>"><?php echo Labels::getLabel('LBL_Meta_Tags_Management', $adminLangId); ?></a>
                            </li>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewUrlRewrite(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('UrlRewriting'); ?>"><?php echo Labels::getLabel('LBL_Url_Rewriting', $adminLangId); ?></a>
                            </li>
                        <?php } ?>
                    </ul>
                </li>
            <?php } ?>
            <?php
            if (
                $objPrivilege->canViewShippingPackages(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewShippingManagement(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewPickupAddresses(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewTrackingRelationCode()
            ) {
                ?>
                <li class="dashboard-menu-item haschild"><button class="dashboard-menu-btn dropdown-toggle-custom collapsed"
                        data-bs-toggle="collapse" data-bs-target="#nav-shipping" aria-expanded="false" title=""
                        type="button">
                        <span class="dashboard-menu-icon">
                            <svg class="svg" width="18" height="18">
                                <use xlink:href="/images/admin/retina/sprite-aside-menu.svg#icon-shipping-pickup">
                                </use>
                            </svg>
                        </span>
                        <span
                            class="dashboard-menu-head "><?php echo Labels::getLabel('LBL_Shipping', $adminLangId); ?></span><i
                            class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>

                    </button>
                    <ul class="menu-sub menu-sub-accordion collapse second-level-nav" id="nav-shipping">
                        <?php if ($objPrivilege->canViewShippingPackages(AdminAuthentication::getLoggedAdminId(), true) && FatApp::getConfig("CONF_PRODUCT_DIMENSIONS_ENABLE", FatUtility::VAR_INT, 1)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('shippingPackages'); ?>"><?php echo Labels::getLabel('LBL_Shipping_Packages', $adminLangId); ?></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewShippingManagement(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('shippingProfile'); ?>"><?php echo Labels::getLabel('LBL_Shipping_Profile', $adminLangId); ?></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewTrackingRelationCode()) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('TrackingCodeRelation'); ?>"><?php echo Labels::getLabel('LBL_Tracking_Code_Relation', $adminLangId); ?></a>
                            </li>
                        <?php } ?>

                        <?php if ($objPrivilege->canViewPickupAddresses(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('PickupAddresses'); ?>"><?php echo Labels::getLabel('LBL_Pickup_Addresses', $adminLangId); ?></a>
                            </li>
                        <?php } ?>
                    </ul>
                </li>
            <?php } ?>
            <?php
            if ($objPrivilege->canViewTax(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                <li class="dashboard-menu-item haschild">
                    <button type="button" class="dashboard-menu-btn dropdown-toggle-custom collapsed"
                        data-bs-toggle="collapse" data-bs-target="#nav-tax" aria-expanded="false" title="">
                        <span class="dashboard-menu-icon">
                            <svg class="svg" width="18" height="18">
                                <use xlink:href="/images/admin/retina/sprite-aside-menu.svg#icon-sales-tax">
                                </use>
                            </svg>
                        </span>
                        <span class="dashboard-menu-head ">
                            <?php echo Labels::getLabel('LBL_Tax', $adminLangId); ?> </span><i
                            class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
                    </button>
                    <ul class="menu-sub menu-sub-accordion collapse second-level-nav" id="nav-tax">
                        <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                href="<?php echo UrlHelper::generateUrl('TaxStructure'); ?>"><?php echo Labels::getLabel('LBL_Tax_Structure', $adminLangId); ?></a>
                        </li>
                        <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                href="<?php echo UrlHelper::generateUrl('Tax'); ?>"><?php echo Labels::getLabel('LBL_Tax_Management', $adminLangId); ?></a>
                        </li>
                    </ul>
                </li>
            <?php }
            ?>
            <!--System Settings-->
            <?php
            if (
                $objPrivilege->canViewGeneralSettings(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewPlugins(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewPaymentMethods(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewCurrencyManagement(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewCommissionSettings(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewSellerPackages(AdminAuthentication::getLoggedAdminId(), true) ||
                $objPrivilege->canViewThemeColor(AdminAuthentication::getLoggedAdminId(), true)
            ) {
                ?>
                <li class="dashboard-menu-item haschild"><button type="button"
                        class="dashboard-menu-btn dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                        data-bs-target="#nav-general-settings" aria-expanded="false" title="">

                        <span class="dashboard-menu-icon">
                            <svg class="svg" width="18" height="18">
                                <use xlink:href="/images/admin/retina/sprite-aside-menu.svg#icon-system-settings">
                                </use>
                            </svg>
                        </span>
                        <span class="dashboard-menu-head ">
                            <?php echo Labels::getLabel('LBL_System_Settings', $adminLangId); ?> </span><i
                            class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
                    </button>
                    <ul class="menu-sub menu-sub-accordion collapse second-level-nav" id="nav-general-settings">

                        <?php if ($objPrivilege->canViewGeneralSettings(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('configurations'); ?>"><?php echo Labels::getLabel('LBL_General_Settings', $adminLangId); ?></a>
                            </li>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewPlugins(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('Plugins'); ?>"><?php echo Labels::getLabel('LBL_PLUGINS', $adminLangId); ?></a>
                            </li>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewThemeColor(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('ThemeColor'); ?>"><?php echo Labels::getLabel('LBL_Theme_Settings', $adminLangId); ?></a>
                            </li>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewCurrencyManagement(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('CurrencyManagement'); ?>"><?php echo Labels::getLabel('LBL_Currency_Management', $adminLangId); ?></a>
                            </li>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewCommissionSettings(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('Commission'); ?>"><?php echo Labels::getLabel('LBL_Commission_Settings', $adminLangId); ?></a>
                            </li>
                        <?php } ?>
                        <?php if ($objPrivilege->canViewSellerPackages(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('SellerPackages'); ?>"><?php echo Labels::getLabel('LBL_Seller_Packages_Management', $adminLangId); ?></a>
                            </li>
                        <?php } ?>
                    </ul>
                </li>
            <?php } ?>

            <?php if ($objPrivilege->canViewImportExport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                <li class="dashboard-menu-item "><a class="dashboard-menu-btn"
                        href="<?php echo UrlHelper::generateUrl('ImportExport'); ?>">
                        <span class="dashboard-menu-icon">
                            <svg class="svg" width="18" height="18">
                                <use xlink:href="/images/admin/retina/sprite-aside-menu.svg#icon-import-export">
                                </use>
                            </svg>
                        </span>
                        <span
                            class="dashboard-menu-head "><?php echo Labels::getLabel('LBL_Import_Export', $adminLangId); ?>
                        </span>

                    </a>
                </li>
            <?php } ?>
            <?php if ($objPrivilege->canViewSitemap(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                <li class="dashboard-menu-item haschild"><button type="button"
                        class="dashboard-menu-btn dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                        data-bs-target="#nav-sitemap" aria-expanded="false" title="">

                        <span class="dashboard-menu-icon">
                            <svg class="svg" width="18" height="18">
                                <use xlink:href="/images/admin/retina/sprite-aside-menu.svg#icon-sitemap">
                                </use>
                            </svg>
                        </span>
                        <span class="dashboard-menu-head ">
                            <?php echo Labels::getLabel('LBL_Sitemap', $adminLangId); ?> </span><i
                            class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
                    </button>
                    <ul class="menu-sub menu-sub-accordion collapse second-level-nav" id="nav-sitemap">
                        <?php if ($objPrivilege->canEditSitemap(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                    href="<?php echo UrlHelper::generateUrl('sitemap', 'generate'); ?>"><?php echo Labels::getLabel('LBL_Update_Sitemap', $adminLangId); ?></a>
                            </li>
                        <?php } ?>
                        <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                href="<?php echo UrlHelper::generateFullUrl('custom', 'sitemap', array(), CONF_WEBROOT_FRONT_URL); ?>"
                                target="_blank"><?php echo Labels::getLabel('LBL_View_HTML', $adminLangId); ?></a>
                        </li>
                        <li class="menu-sub-item"><a class="menu-sub-link navLinkJs"
                                href="<?php echo UrlHelper::generateFullUrl('', '', array(), CONF_WEBROOT_FRONT_URL) . 'sitemap.xml'; ?>"
                                target="_blank"><?php echo Labels::getLabel('LBL_View_XML', $adminLangId); ?></a>
                        </li>
                    </ul>
                </li>
            <?php } ?>
            <?php if (CommonHelper::demoUrl() && 0) { ?>
                <li>
                    <div class="m-4 text-center">
                        <a class="themebtn btn-brand outline block" href="https://www.yo-rent.com/suggest-feature.html"
                            target="_blank">
                            <?php echo Labels::getLabel('LBL_SUGGEST_A_FEATURE', $adminLangId); ?>
                        </a>
                    </div>
                </li>
            <?php } ?>
        </ul>
    </div>
</sidebar>
<!--left panel end here-->