<?php

class TaxStructureController extends AdminBaseController
{
    private $canEdit;

    public function __construct($action)
    {
        parent::__construct($action);
        $this->objPrivilege->canViewTax();
    }

    public function index()
    {
        $this->set("canEdit", $this->objPrivilege->canEditTax($this->admin_id, true));
        $this->_template->render();
    }

    public function search()
    {
        $srch = TaxStructure::getSearchObject($this->adminLangId);
        $srch->doNotCalculateRecords();
        $srch->doNotLimitRecords();
        $srch->addCondition('taxstr_parent', '=', 0);
        $srch->addOrder('taxstr_id', 'DESC');
        $rs = $srch->getResultSet();
        $records = FatApp::getDb()->fetchAll($rs);
        $this->set("listing", $records);

        $this->canEdit = $this->objPrivilege->canEditTax($this->admin_id, true);
        $this->set("canEdit", $this->canEdit);
        $this->_template->render(false, false);
    }

    public function form($taxStrId = 0)
    {
        $this->objPrivilege->canEditTax();
		$taxStrId = FatUtility::int($taxStrId);
		
        $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
		$languages = Language::getAllNames();
       
        $frm = TaxStructure::getForm($this->adminLangId, $taxStrId);
        $taxStrData = [];
        $combinedTaxes = [];
        if (0 < $taxStrId) {
			$taxStrData = TaxStructure::getAttributesById($taxStrId);
            foreach ($languages as $langId => $data) {
                $taxStructure = new TaxStructure();
                $taxStrLangData = $taxStructure->getAttributesByLangId($langId, $taxStrId);
                if (!empty($taxStrLangData)) {
                    $taxStrData['taxstr_name'][$langId] = $taxStrLangData['taxstr_name'];
                }
                if ($taxStrData['taxstr_is_combined']) {
                    $combinedTaxes = $taxStructure->getCombinedTaxes($taxStrId);
                }
            }
			
            if ($taxStrData === false) {
                FatUtility::dieWithError($this->str_invalid_request);
            }
            $frm->fill($taxStrData);
        }
		/* CommonHelper::printArray($combinedTaxes); die; */
		$langData = Language::getAllNames();
        unset($langData[$siteDefaultLangId]);
        $this->set('combinedTaxes', $combinedTaxes);
        $this->set('taxStrData', $taxStrData);
        $this->set('otherLangData', $langData);
        $this->set('siteDefaultLangId', $siteDefaultLangId);
        $this->set('languages', Language::getAllNames());
        $this->set('taxStrId', $taxStrId);
        $this->set('frm', $frm);
        $this->_template->render(false, false);
    }

    public function setup()
    {
        $this->objPrivilege->canEditTax();

        $frm = TaxStructure::getForm($this->adminLangId);
        $post = FatApp::getPostedData();
		
        if (false === $post) {
            Message::addErrorMessage(current($frm->getValidationErrors()));
            FatUtility::dieJsonError(Message::getHtml());
        }


        if(!empty($post['taxstr_id'])){
            $srch = TaxRule::getSearchObject();
            $srch->joinTable(TaxRule::DB_RATES_TBL, 'INNER JOIN', TaxRule::tblFld('id') . '=' . TaxRule::DB_RATES_TBL_PREFIX . TaxRule::tblFld('id') . ' and ' . TaxRule::DB_RATES_TBL_PREFIX . 'user_id = 0');
            $srch->joinTable(TaxStructure::DB_TBL, 'INNER JOIN', "taxstr_id = taxrule_taxstr_id AND taxrule_taxstr_id = $post[taxstr_id]");
            $srch->addMultipleFields(array('taxrule_id', 'taxrule_name', 'trr_rate', 'taxrule_taxstr_id', 'taxrule_taxcat_id','taxstr_is_combined'));
            $srch->doNotCalculateRecords();
            $srch->doNotLimitRecords();
            $records = FatApp::getDb()->fetch($srch->getResultSet());
            if($records && $records['taxstr_is_combined'] != ($post['taxstr_is_combined']??0) ){
                FatUtility::dieJsonError(Labels::getLabel('LBL_Type_cannot_be_changed_as_it_has_been_assigned_to_the_Tax_Category', $this->adminLangId));                
            }
        }
        $taxStrId = $post['taxstr_id'];
        unset($post['taxstr_id']);
		
        $record = new TaxStructure($taxStrId);
        if (!$record->addUpdateData($post)) {
            Message::addErrorMessage($record->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }

        $this->set('msg', $this->str_setup_successful);
        $this->_template->render(false, false, 'json-success.php');
    }
	
	public function translatedData()
    {
        $taxstrName = FatApp::getPostedData('taxstrName', FatUtility::VAR_STRING, '');
        $toLangId = FatApp::getPostedData('toLangId', FatUtility::VAR_INT, 0);
        $data['taxstr_name'] = $taxstrName;
        $taxStructure = new TaxStructure();
        $translatedData = $taxStructure->getTranslatedData($data, $toLangId);
        if (!$translatedData) {
            Message::addErrorMessage($taxStructure->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }
        $this->set('taxstrName', $translatedData[$toLangId]['taxstr_name']);
        $this->_template->render(false, false, 'json-success.php');
    }

    public function deleteRecord()
    {
       
        $this->objPrivilege->canEditTax();
        $id = FatApp::getPostedData('id', FatUtility::VAR_INT, 0);
        
        if (1 > $id) {
            FatUtility::dieJsonError($this->str_invalid_request_id);
        }

        if(!empty(TaxStructure::getAttachedProducts($id))){
            FatUtility::dieJsonError(Labels::getLabel('LBL_The_Category_cannot_be_removed_as_it_has_been_assigned_to_the_products', $this->adminLangId));
        }

        $taxRule = new TaxStructure($id);
        if (!$taxRule->deleteRecord()) {
            FatUtility::dieJsonError($taxRule->getError());
        }

        FatUtility::dieJsonSuccess($this->str_delete_record);
    }
}
