<?php

class ChecklistPointsController extends AdminBaseController
{

    public function __construct($action)
    {
        parent::__construct($action);

        $this->admin_id = AdminAuthentication::getLoggedAdminId();
        $this->objPrivilege->canViewChecklistPoints($this->admin_id);
    }

    public function form()
    {
        $this->objPrivilege->canEditChecklistPoints();
        $prodCatId = FatApp::getPostedData('prodCategoryId', FatUtility::VAR_INT, 0);
        if (0 > $prodCatId) {
            FatUtility::dieWithError($this->str_invalid_request);
        }

        $checklistPointData = array('cp_record_id' => $prodCatId);
        $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
        $frm = $this->getForm();

        $cpId = FatApp::getPostedData('cpId', FatUtility::VAR_INT, 0);
        if ($cpId > 0) {

            $srch = ChecklistPoint::getSearchObjectByLang();
            $srch->addMultipleFields(array('cp.cp_id', 'cp.cp_type', 'cp.cp_record_id', 'IFNULL(cp_name, cp_identifier) as cp_name', 'cp_options', 'cplang_lang_id'));
            $srch->addCondition('cp.cp_id', '=', $cpId);
            $srch->doNotCalculateRecords();
            $checklistPointFormData = FatApp::getDb()->fetchAll($srch->getResultSet(), 'cplang_lang_id');
            $response = array();
            $langSpecificFlds = array('cp_name', 'cp_options');

            if (!empty($checklistPointFormData)) {
                foreach ($checklistPointFormData as $lang => $data) {
                    foreach ($data as $key => $value) {
                        if (in_array($key, $langSpecificFlds)) {
                            $response[$key][$lang] = $value;
                        } else {
                            $response[$key] = $value;
                        }
                    }
                }
            }
            $checklistPointData = $response;
        }

        $frm->fill($checklistPointData);

        $languages = Language::getAllNames();
        unset($languages[$siteDefaultLangId]);

        $this->set('prodCatId', $prodCatId);
        $this->set('cpId', $cpId);
        $this->set('frm', $frm);
        $this->set('otherLangData', $languages);
        $this->set('siteDefaultLangId', $siteDefaultLangId);
        $this->_template->render(false, false);
    }

    public function setup()
    {
        $this->objPrivilege->canEditChecklistPoints();

        $frm = $this->getForm();
        $post = $frm->getFormDataFromArray(FatApp::getPostedData());
        if ($post == false) {
            FatUtility::dieWithError(current($frm->getValidationErrors()));
        }

        $languages = Language::getAllNames();
        $cpRecordId = FatUtility::int($post['cp_record_id']);
        $cpId = FatUtility::int($post['cp_id']);

        $dataToSaveArr = array(
            'cp_record_id' => $cpRecordId,
            'cp_identifier' => $post['cp_name'][$this->adminLangId],
            'cp_type' => $post['cp_type']
        );

        $record = new ChecklistPoint($cpId);
        $record->assignValues($dataToSaveArr);
        if (!$record->save()) {
            FatUtility::dieWithError($record->getError());
        }
        foreach ($languages as $key => $language) {
            $data = array(
                'cp_name' => $post['cp_name'][$key],
                'cp_options' => $post['cp_options'][$key],
            );

            $this->cpFldLangSetup($record->getMainTableRecordId(), $data, $key);
        }

        $this->set('msg', $this->str_update_record);
        $this->set('attr_id', $record->getMainTableRecordId());
        $this->set('lang_id', 1);
        $this->_template->render(false, false, 'json-success.php');
    }

    public function changeStatus()
    {
        $this->objPrivilege->canEditChecklistPoints();
        $post = FatApp::getPostedData();
        $cpId = FatUtility::int($post['cpId']);
        $status = FatApp::getPostedData('status', FatUtility::VAR_INT, 0);

        if (1 > $cpId) {
            FatUtility::dieWithError(Labels::getLabel('MSG_INVALID_REQUEST', $this->adminLangId));
        }

        $updateArray = array('cp_active' => $status);
        $whr = array('smt' => 'cp_id = ?', 'vals' => array($cpId));
        if (!FatApp::getDb()->updateFromArray(ChecklistPoint::DB_TBL, $updateArray, $whr)) {
            Message::addErrorMessage('something went worng');
            FatUtility::dieJsonError(Message::getHtml());
        }

        FatUtility::dieJsonSuccess(Labels::getLabel('MSG_RECORD_STATUS_UPDATED_SUCCESSFULLY', $this->adminLangId));
    }

    public function listing()
    {
        $post = FatApp::getPostedData();
        $prodCatId = FatUtility::int($post['catId']);
        $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);

        if (1 > $prodCatId) {
            Message::addErrorMessage(Labels::getLabel('MSG_INVALID_REQUEST', $this->adminLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $checklistPointObj = new ChecklistPoint($prodCatId);
        $checklistPointFldData = $checklistPointObj->getDetail($this->adminLangId);

        $this->set('checklistPointFldData', $checklistPointFldData);
        $this->set('checklistTypes', ChecklistPoint::getChecklistTypesArr($siteDefaultLangId));
        $this->_template->render(false, false);
    }

    private function cpFldLangSetup(int $cpId, array $data, int $langId)
    {

        if ($cpId < 1 || $langId < 1 || empty($data)) {
            Message::addErrorMessage(Labels::getLabel('MSG_Invalid_Request', $this->adminLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $data_to_update = array(
            'cplang_cp_id' => $cpId,
            'cplang_lang_id' => $langId,
            'cp_name' => $data['cp_name'],
        );
        if (isset($data['cp_options'])) {
            $data_to_update['cp_options'] = $data['cp_options'];
        }
        $checklistPointObj = new ChecklistPoint($cpId);
        if (!$checklistPointObj->updateLangData($langId, $data_to_update)) {
            Message::addErrorMessage($checklistPointObj->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }

        return true;
    }

    private function getForm()
    {
        $this->objPrivilege->canEditChecklistPoints();
        $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
        $checklistPointsTypes = ChecklistPoint::getChecklistTypesArr($siteDefaultLangId);
        $languages = Language::getAllNames();
        unset($languages[$siteDefaultLangId]);

        $frm = new Form('frmChecklistPoint', array('id' => 'frmChecklistPoint'));

        $frm->addRequiredField(Labels::getLabel('LBL_Field_Name', $siteDefaultLangId), 'cp_name[' . $siteDefaultLangId . ']');
        $fldType = $frm->addSelectBox(Labels::getLabel('LBL_Field_type', $siteDefaultLangId), 'cp_type', $checklistPointsTypes, '', array(), '');

        $fld = $frm->addTextArea(Labels::getLabel('LBL_Option_Data', $siteDefaultLangId), 'cp_options[' . $siteDefaultLangId . ']');
        $fld->htmlAfterField = '<small class="text--small form-text text-muted">'.Labels::getLabel('LBL_Enter_Data_Separated_By_New_Line:<br>_E.g:', $siteDefaultLangId) . '<br />' . Labels::getLabel('LBL_Yes', $siteDefaultLangId) . '<br />' . Labels::getLabel('LBL_NO', $siteDefaultLangId).'</small>';

        $optionDataFldReqObj = new FormFieldRequirement('cp_options[' . $siteDefaultLangId . ']', Labels::getLabel('LBL_Option_Data', $siteDefaultLangId));
        $optionDataFldReqObj->setRequired(true);

        $optionDataFldUnReqObj = new FormFieldRequirement('cp_options[' . $siteDefaultLangId . ']', Labels::getLabel('LBL_Option_Data', $siteDefaultLangId));
        $optionDataFldUnReqObj->setRequired(false);

        $fldType->requirements()->addOnChangerequirementUpdate(ChecklistPoint::CHECKLISTTYPE_CHECKBOXES, 'eq', 'cp_options[' . $siteDefaultLangId . ']', $optionDataFldReqObj);
        $fldType->requirements()->addOnChangerequirementUpdate(ChecklistPoint::CHECKLISTTYPE_CHECKBOXES, 'ne', 'cp_options[' . $siteDefaultLangId . ']', $optionDataFldUnReqObj);
        $frm->addHiddenField('', 'cp_record_id');
        $frm->addHiddenField('', 'cp_id');
        $frm->addHiddenField('', 'lang_id', $siteDefaultLangId);

        foreach ($languages as $key => $language) {
            $frm->addTextBox(Labels::getLabel('LBL_Field_Name', $key), 'cp_name[' . $key . ']');

            $fld = $frm->addTextArea(Labels::getLabel('LBL_Option_Data', $key), 'cp_options[' . $key . ']');
            $fld->htmlAfterField = '<small class="text--small form-text text-muted">'.Labels::getLabel('LBL_Enter_Data_Separated_By_New_Line:<br>_E.g:', $key) . '<br />' . Labels::getLabel('LBL_Yes:', $key) . '<br />' . Labels::getLabel('LBL_NO:', $key).'</small>';
        }

        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Save', $this->adminLangId), array('class' => 'btn btn-brand btn-submit'));
        $frm->addButton('', 'btn_discard', Labels::getLabel('LBL_Clear', $this->adminLangId), array('class' => 'btn btn-gray btn-clear'));
        return $frm;
    }

}
