<p align="center">
	<a href="https://www.yo-rent.com" target="_blank"><img src="https://www.yo-rent.com/images/retina/yo-rent-logo.svg" width="400"></a>
</p>


**<p align="center">Version RV-3.2</p>**

## About Yo!Rent

Yo!Rent is an advanced eCommerce rental software that enables startups and SMBs to launch a customizable, self- hosted, multi-vendor rental marketplace with a lifetime license. Yo!Rent offers an array of multi-vendor functionalities such as advanced renting and selling options, mobile-ready platform, intuitive UX design, in-built analytics and reporting, and search engine optimization. Built on the back of extensive industry research, these features are essential for the success and growth of an eCommerce rental marketplace. 


## Version History

- **Version 3.2**: Revamped Admin Dashboard, Single Product Form in Admin dashboard, Hourly Rental Option, Option to configure all four prices (Hour, Day, Week, Month), Flexible Payment Options, Distance-Based Shipping.
- **Version 3.1**: Compatibility with PHP 8.1, Revamped buyer, seller, advertiser Dashboard , Single Product Form in seller dashboard, Google Analytics 4 / GA4, Recaptcha integration on registration page, Integrated Stripe hosted checkout, PWA integration, Interated updated version of Mailchimp, Updated the Social logins (login with Facebook, google, Apple etc), Added new CMS colletion in Fashion, furniture, event theme (Collection with Content and image), Updated the Engagespot push notification.
- **Version 3.0**: Option for Rent as well as Sale, RFQ request for quote, Dcoument verification at checkout, Special price, Duration discounts, Cancellation penality rules for Rental orders, Agreement management & e-sign (Canvas), Equipment inspection & rental return, Size chart and other files upload option, Custom fields & filters, Product Comparison, Shipping module, Pick up locations enhancement, Tax module, Add-Ons Module, Rental item return after rental period is over, Search enhancement, Late charges, Map view for shops & products.

## System Requirements

You will require the following server specifications for setting up the Yo!Rent scripts:

- Environment : LAMP (Linux, Apache, MySQL, and PHP)
   - Supported Operating Systems: 
       - Linux x86
       - x86-64
   - Supported Web Servers: 
       - Apache 2.4.x
       - Nginx
   - PHP Compatibility: 8.1
   - Server Hosting :
       - Ability to run scheduled jobs.
       - Ability to override options in .htaccess files
   - Required Extensions:
       - GD with Free Font support
       - Zlib with zip support
       - JSON
       - DOM
       - cURL function should be enabled
       - Mbstring should be enabled
       - Iconv function should be enabled
       - Fileinfo function should be enabled
       - Calendar function should be enabled
       - Ioncube Loader
       - PHP Composer should be installed
       - Memory_limit 64M or more (Some pages with advanced feature may need upto 128M)
       - bcmath
   - My SQL:
       - 5.7 or greater
       - sql_mode - strict_trans_tables should be disabled.


## System Requirements

The following technical requirements are needed to set up Yo!Rent:

| SrNo | Software | Version | Help|
| ------------ | ------------ | ------------ | ------------ |
| 1 | Ubuntu x86, x86-64 | 20.04+  | [Ubuntu](https://ubuntu.com/)  |
| 2 | Web Servers | Apache 2.4.x | [Apache](https://httpd.apache.org/)  | 
| 3 | PHP Version | 8.1.x |  [PHP](https://www.php.net/) | 
| 4 | MySQL Version | 8.0.x | [MySQL](https://www.mysql.com/)  | 


## Installation Instructions

1. **Prerequisite**

	- You are able to aceess the server using **SSH**.
	- You have installed **Apache** , **MySql** and **PHP** on linux server.
	- You have installed ioncube loader compatible to **Fatbit library v2.4**

1. **Clone Yo!Rent**

    Install git and clone Clone Yo!Rent to your root directory.

		sudo apt install git
		git --version
		cd ./path/to/your/rootdir
		git clone git@github.com:AblySoft268/yorent-marketplace-fashion.git .
		
    **Note:** OR if you have script files, Upload script files to the root directory and continue.

2. **Copy setup-files files**

    Copy `conf` `user-uploads` `public` `mbs-errors.log` and everything from `setup-files` to root directory.

		cp -r setup-files/* .

3. **Install Dependencies**

    It will update versions of packages to be installed with your system.

		composer install

4. **Import Database**

    We have `multi_category_sample.sql` (with default data) and `multi_category_blank.sql`(without default data) database in `database` directory. Database can be imported as per requirement.

		mysql -u mysqlUsername -p mysqlDatabase < database/multi_category_sample.sql
		mysqlPassword

5. **Connect Database**

    Configure MySQL database connection settings in `public/settings.php`

		nano public/settings.php
    `settings.php` file will look like below

		<?php
		define('CONF_WEBROOT_FRONTEND', '/');
		define('CONF_WEBROOT_BACKEND', '/admin/');
		define('CONF_DB_SERVER', 'localhost');
		define('CONF_DB_USER', 'mysqlUsername');
		define('CONF_DB_PASS', 'mysqlPassword');
		define('CONF_DB_NAME', 'mysqlDatabase');
    Save and Exit (Ctrl+x and Shift+y)
	
6. **Clone user-uploads - (Optional)**

    Only Required If we have `multi_category_sample.sql` (with default data) Database 

		wget https://download.yorent-v2.4livedemo.com/multi-cat-user-uploads.zip
		unzip multi-cat-user-uploads.zip
		rm multi-cat-user-uploads.zip
		sudo chmod -R 777 user-uploads	

7. **Grant Permissions**

		chmod -R 777 user-uploads
		chmod -R 777 public/cache
		chmod 777 mbs-errors.log

8. **Upload License**
		Upload provided license file "license.txt" to ‘/library/’ in the scripts
		Or
		nano /library/license.txt
    Paste license key and Save and Exit (Ctrl+x and Shift+y)

9. **Setup Cron Job**

		crontab -e
		*/2 * * * * /usr/bin/curl  -s https://yourdomain.com/cron > /dev/null 2>&1
    Save and Exit (Ctrl+x and Shift+y)
    **Note:** The command may vary depending upon the products and their version.

10. **Create Procedure**

    - Login to admin dashboard 
	- Open url https://yourdomain.com/admin/admin-users/createProcedures to create procedures.

11. **Custom Configuration**

    Update `{root}/conf/conf-common.php` as per your requirements
		
		define('CONF_DEVELOPMENT_MODE', false);
		define('CONF_USE_FAT_CACHE', true);
		define('ALLOW_EMAILS', true);


## Notes:

- S3 bucket notes for bulk media:
	- Create a Lambda function.
	-	 Add trigers and upload zip file from  git-ignored-files/user-uploads/lib-files/fatbit-s3-zip-extractor.zip.
	- Set permission and update Resource based on function created by you.
		
    	    {
            "Version": "2012-10-17",
            "Statement": [
                {
                    "Effect": "Allow",
                    "Action": "logs:CreateLogGroup",
                    "Resource": "arn:aws:logs:us-east-2:765751105868:*"
                },
                {
                    "Effect": "Allow",
                    "Action": [
                        "logs:CreateLogStream",
                        "logs:PutLogEvents"
                    ],
                    "Resource": "arn:aws:logs:*:*:*"
                },
                {
                    "Effect": "Allow",
                    "Action": [
                        "s3:PutObject",
                        "s3:GetObject",
                        "s3:DeleteObject"
                    ],
                    "Resource": [
                        "*"
                    ]
                }
            ]
        }